using System;
public class Program
{
    public struct Mast
    {
        public long X;
        public long H;
        public int OriginalIndex;
    }
    public class MastComparer : System.Collections.IComparer
    {
        public int Compare(object x, object y)
        {
            Mast a = (Mast)x;
            Mast b = (Mast)y;
            return a.X.CompareTo(b.X);
        }
    }
    public static void Main()
    {
        Solve();
    }
    public static void Solve()
    {
        const double MAX_DIST = 2e18; 
        string line1 = Console.ReadLine();
        if (line1 == null || !int.TryParse(line1, out int n))
            return;
        string xLine = Console.ReadLine();
        string[] xParts = xLine.Split(new char[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
        long[] xCoords = new long[n];
        for(int i = 0; i < n; i++)
        {
            xCoords[i] = Convert.ToInt64(xParts[i]);
        }
        string hLine = Console.ReadLine();
        string[] hParts = hLine.Split(new char[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
        long[] hHeights = new long[n];
        for(int i = 0; i < n; i++)
        {
            hHeights[i] = Convert.ToInt64(hParts[i]);
        }
        Mast[] initialMasts = new Mast[n];
        for (int i = 0; i < n; i++)
        {
            initialMasts[i] = new Mast { X = xCoords[i], H = hHeights[i], OriginalIndex = i };
        }
        Mast[] sortedMasts = (Mast[])initialMasts.Clone();
        Array.Sort(sortedMasts, new MastComparer());
        double[] results = new double[n];
        int[] leftHigherMastIndex = new int[n];
        int[] rightHigherMastIndex = new int[n];
        for(int i = 0; i < n; i++)
        {
            leftHigherMastIndex[i] = -1;
            rightHigherMastIndex[i] = -1;
        }
        int[] stackArray = new int[n];
        int stackPointer = -1;

        for (int i = 0; i < n; i++)
        {
            while (stackPointer >= 0 && sortedMasts[stackArray[stackPointer]].H < sortedMasts[i].H)
            {
                stackPointer--;
            }
            if (stackPointer >= 0)
            {
                leftHigherMastIndex[i] = stackArray[stackPointer];
            }
            while (stackPointer >= 0 && sortedMasts[stackArray[stackPointer]].H == sortedMasts[i].H)
            {
                stackPointer--;
            }
            
            stackPointer++;
            stackArray[stackPointer] = i;
        }
        stackPointer = -1;
        for (int i = n - 1; i >= 0; i--)
        {
            while (stackPointer >= 0 && sortedMasts[stackArray[stackPointer]].H < sortedMasts[i].H)
            {
                stackPointer--;
            }
            if (stackPointer >= 0)
            {
                rightHigherMastIndex[i] = stackArray[stackPointer];
            }
            while (stackPointer >= 0 && sortedMasts[stackArray[stackPointer]].H == sortedMasts[i].H)
            {
                stackPointer--;
            }
            stackPointer++;
            stackArray[stackPointer] = i;
        }
        for (int i = 0; i < n; i++)
        {
            Mast currentMast = sortedMasts[i];
            double minDistance = MAX_DIST;
            int lIndex = leftHigherMastIndex[i];
            if (lIndex != -1)
            {
                Mast lMast = sortedMasts[lIndex];
                double dist = Math.Sqrt(Math.Pow(lMast.X - currentMast.X, 2) + Math.Pow(lMast.H - currentMast.H, 2));
                minDistance = Math.Min(minDistance, dist);
            }
            int rIndex = rightHigherMastIndex[i];
            if (rIndex != -1)
            {
                Mast rMast = sortedMasts[rIndex];
                double dist = Math.Sqrt(Math.Pow(rMast.X - currentMast.X, 2) + Math.Pow(rMast.H - currentMast.H, 2));
                minDistance = Math.Min(minDistance, dist);
            }
            if (i > 0)
            {
                Mast prevMast = sortedMasts[i - 1];
                if (prevMast.H > currentMast.H)
                {
                    double h_i = currentMast.H;
                    double x_T = (double)prevMast.X + prevMast.H - h_i;
                    double xP = ((double)(prevMast.X + prevMast.H) + (currentMast.X - currentMast.H)) / 2.0;
                    if (x_T >= (double)prevMast.X && x_T <= xP)
                    {
                        double dist = currentMast.X - x_T;
                        minDistance = Math.Min(minDistance, dist);
                    }
                }
            }
            if (i < n - 1)
            {
                Mast nextMast = sortedMasts[i + 1];
                if (nextMast.H > currentMast.H)
                {
                    double h_i = currentMast.H;
                    double x_T = (double)nextMast.X + h_i - nextMast.H;
                    double xP = ((double)(currentMast.X + currentMast.H) + (nextMast.X - nextMast.H)) / 2.0;
                    if (x_T >= xP && x_T <= (double)nextMast.X)
                    {
                        double dist = x_T - currentMast.X;
                        minDistance = Math.Min(minDistance, dist);
                    }
                }
            }
            if (minDistance >= MAX_DIST)
            {
                results[currentMast.OriginalIndex] = -1;
            }
            else
            {
                results[currentMast.OriginalIndex] = Math.Round(minDistance);
            }
        }
        for(int i = 0; i < n; i++)
        {
            double res = results[i];
            if (res < 0)
            {
                Console.WriteLine("-1");
            }
            else
            {
                Console.WriteLine(Convert.ToInt64(res));
            }
        }
    }
}